<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateConfigurationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('configurations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('config_name');
            $table->integer('aircraft_type_id')->unsigned();
            $table->foreign('aircraft_type_id')->references('id')->on('aircraft_types');

            $table->integer('manufacturer_id')->unsigned();
            $table->foreign('manufacturer_id')->references('id')->on('manufacturers');

            $table->integer('aircraft_model_id')->unsigned();
            $table->foreign('aircraft_model_id')->references('id')->on('aircraft_models');

            $table->integer('variant_id')->unsigned();
            $table->foreign('variant_id')->references('id')->on('variants');

            $table->integer('config_image_id')->unsigned();
            $table->foreign('config_image_id')->references('id')->on('configuration_images');

            $table->string('remark');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('configurations');
    }
}
